(* About integer powers (monomorphic version) *)



Set Implicit Arguments.

Require Import ZArith.

Require Import Div2.

Require Import Program.

Open Scope Z_scope.

Fixpoint power (a:Z)(n:nat) :=
  match n with 0%nat => 1
             | S p =>  a * power a p
  end.

Eval vm_compute in power 2 40.

Program
Fixpoint binary_power_mult (acc x:Z) (n:nat) {measure n} : Z
  (* acc * (power x n) *) :=
  match n with 
    | 0%nat => acc
    | _ => if Even.even_odd_dec n
           then binary_power_mult acc (x * x) (div2 n)
           else binary_power_mult (acc * x) (x * x) (div2 n)
  end.
 Solve Obligations with program_simpl; intros; apply lt_div2; auto with arith.





Definition binary_power (x:Z)(n:nat) := binary_power_mult 1 x n.

Eval vm_compute in binary_power 2 40.

Goal binary_power 2 234 = power 2 234.
reflexivity.
Qed.

