#!/bin/bash
#
source ./install-env.sh
INSTALLDIR=$CLUSTER_INSTALL_DIR
TMPDIR=$CLUSTER_INSTALL_DIR/tmp
IP=$1
echo "[Start]: Computer "$IP
echo "-- Copying"
ssh $IP "mkdir -p $TMPDIR"
scp -r ../install_files $IP:$TMPDIR/FILES
echo "-- Untaring"
ssh $IP "mkdir -p $INSTALLDIR"
ssh $IP "cd $INSTALLDIR;tar xzvf $TMPDIR/FILES/hadoop* > $TMPDIR/res.txt"
ssh $IP "cd $INSTALLDIR;tar xzvf $TMPDIR/FILES/jdk*    > $TMPDIR/res.txt"
ssh $IP "cd $INSTALLDIR;tar xzvf $TMPDIR/FILES/hbase*  > $TMPDIR/res.txt"
ssh $IP "cd $INSTALLDIR;tar xvzf $TMPDIR/FILES/spark*  > $TMPDIR/res.txt"
ssh $IP "mv $INSTALLDIR/jdk*     $INSTALLDIR/jdk"
ssh $IP "mv $INSTALLDIR/hbase*   $INSTALLDIR/hbase"
ssh $IP "mv $INSTALLDIR/hadoop*  $INSTALLDIR/hadoop"
ssh $IP "mv $INSTALLDIR/spark*   $INSTALLDIR/spark"
ssh $IP "rm -fr $TMPDIR/FILES; rm $TMPDIR/res.txt"
echo "[done]"
