usage ()
{
  echo 'Usage : gen-cremi-hosts.sh <room_number> <starting_number> <number_of_machines>'
  exit
}

if [ "$#" -ne 3 ]
then
  usage
fi

ROOM=$1
STARTING_IP=$2
EXPECTED_HOST_NB=$3
TOTAL_REACHED=0
if [ -f hosts ]
then
 rm hosts;
fi
echo "gen for room $ROOM, with $EXPECTED_HOST_NB machines"
for IP in $(seq $STARTING_IP $(($EXPECTED_HOST_NB + $STARTING_IP - 1)))
do
	HOST_IP=10.0.$ROOM.$IP
	ssh -o ConnectTimeout=1 $HOST_IP "ls" > /dev/null 2> /dev/null;
	if [ $? -eq 0 ]
	then
		echo "$HOST_IP is up"
		echo $HOST_IP >> hosts
		TOTAL_REACHED=$(($TOTAL_REACHED + 1))
	else
		echo "$HOST_IP is down"
	fi
done;
echo "Reached $TOTAL_REACHED/$EXPECTED_HOST_NB expected hosts"
