:- module(analyze, [iv/2,find_array_ref/3,workingset/2,integer_constant/2,loopindex/2]).

integer_constant(X,Y):-
	(integer(X),Y=X;numbervars(X,0,End),End == 0,Y is X).

/* Finds all array references in a code for an array */
merge_substitution([],L,L).
merge_substitution([A/_|L1],L2,L3):-
    member(A/_,L2),
    merge_substitution(L1,L2,L3),!.
merge_substitution([A/X|L1],L2,[A/X|L3]):-
    merge_substitution(L1,L2,L3).

iv(for(I,_,_,_,B),[I|L]):-
	iv(B,L),!.
iv(P1;P2,L1):-
	iv(P1,L1),
	iv(P2,L2),
	length(L1,I),
	length(L2,J),
	I>J,!.
iv(P1;P2,L2):-
	iv(P1,_),
	iv(P2,L2),!.
iv(_,[]).

find_array_ref(A,for(_,_,_,B),L):-
    find_array_ref(A,B,L),!.

find_array_ref(A,Z,L3):-
    Z=..[Op,Z1,Z2],
    Op \= '.',
    find_array_ref(A,Z1,L1),
    find_array_ref(A,Z2,L2),
    merge_substitution(L1,L2,L3),!.

find_array_ref(A,[A|T],[[A|T]/NEW]):-    
    new_name(scalar,NEW),!.

find_array_ref(_,_,[]).
    
/* Finds for each statement its execution context */
/*find_context(for(I,LB,UB,1,B),C,R,W):-
	find_context(B,[LB<=I,I<=UB|C],R,W),!.
find_context(for(I,LB,UB,S,B),C,R,W):-
	find_context(B,[0<=K,I = K*S,LB+I<=UB |C],R,W),!.
find_context(B1;B2,C,R3,W3):-
	find_context(B1,C,R1,W1),
	find_context(B2,C,R2,W2),
	append(R1,R2,R3),
	append(W1,W2,W3),!.
find_context(E,C,R,[write(V,C)|W]):-
	E=..[Op,V|E2],
	member(Op,[=,+=,-=,*=,/=]),
	find_context(E2,C,R,W),!.
find_context(array(A,T),C,[read(array(A,T),C)],[]):-!.
find_context(E,C,R3,W3):-
	E=..[_,E1,E2],
	find_context(E1,C,R1,W1),
	find_context(E2,C,R2,W2),
	append(R1,R2,R3),
	append(W1,W2,W3),!.
find_context(_,_,[],[]).
	*/

/* Finds working set */

workingset(for(id(I,_)@=LB,UB,STEP,B),W,L):-
	workingset(LB,W0,L),
	workingset(UB,W1,[I|L]),
	ord_union(W0,W1,W2),
	workingset(STEP,W3,[I|L]),
	ord_union(W2,W3,W4),
        workingset(B,W5,[I|L]),
	ord_union(W4,W5,W),!.
workingset(if(C,P1,P2),W,L):-
        workingset(C,W0,L),
        workingset(P1,W1,L),
	workingset(P2,W2,L),
	ord_union(W0,W1,W3),
	ord_union(W3,W2,W),!.
workingset(if(C,P),W,L):-
        workingset(C,W0,L),
        workingset(P,W1,L),
	ord_union(W0,W1,W),!.
workingset(B1;B2, W,Loop):-
        workingset(B1,W1,Loop),
        workingset(B2,W2,Loop),
        ord_union(W1,W2,W),!.
/* No nonindex variables in indices */
workingset([],[],_).
workingset([H|L],W,Loop):-
	workingset(H,WH,Loop),
	workingset(L,WL,Loop),
	ord_union(WH,WL,W),!.
workingset(id(A,T),[id(A,T)],L):-
	\+ integer(A),
	\+ member(A,L),!.
workingset(E,[],_):-atom(E),!.
workingset(E,[],_):-atomic(E),!.
workingset(star(E),L,Loop):-
	workingset(E,L,Loop),!.
workingset(E,W,Loop):-
	E=..[_|L],
	workingset(L,W,Loop),!.
workingset(E,W):-workingset(E,W,[]).

loopindex(for(id(I,T)@=_,_,_,B),L2):-
	loopindex(B,L),
	ord_union(L,[id(I,T)],L2),!.
loopindex(B1;B2,L):-
	loopindex(B1,L1),
	loopindex(B2,L2),
	ord_union(L1,L2,L),!.
loopindex(if(_,B1,B2),L):-
	loopindex(B1,L1),
	loopindex(B2,L2),
	ord_union(L1,L2,L),!.
loopindex(if(_,B),L):-
	loopindex(B,L),!.
loopindex(_,[]).