/*
 PROLOG FILE FOR X LANGUAGE.
 Needs swi prolog file
 12/2005: creation, Denis Barthou, Sebastien Donadio
 3/2006: output in multiple files, more complete program representation
         modules for optimization and C pretty printer
*/

/****************** PROGRAM SYNTAX ***************************
    statement -> for(counter, lower, upper, stride, statement)
    | statement ; statement
    | assignment
    | vector_operation
    | memcpy
    assignment -> access assignop expression
    vector_operation -> vector( access, access, access)
    memcpy -> memcpy(access, access, index, lower, upper)
    access -> array(name, [index]) | name
    expression -> binaryop(expression,expression)
    | access
    assignop -> @= | += | *= | /= | ~= | ^= | &= | #= | <<= | >>=
*/

/******************* EXAMPLES ********************************
 Find sequence of optimization

    optimize(for(i,0,n,1,for(j,0,m,1,(array(a,[i,j])=array(b,[i,j])))),X,[U]),
    optimize(X,Y,[V]),
    optimize(Y,Z,[W]),
    print(U),print(V),print(W),nl,
    print_code(Z,0),nl,nl,fail.

 X language like optimization
    optimize(for(i,0,100,1,for(j,0,50,1,(array(a,[i])=array(b,[j])))),X,[[sm,i,U,10]]),
    optimize(X,Y,[[inter,U,j]]),
    print_code(Y,0),fail.

 Compute volume of operations
    optimize(for(i,0,100,1,for(j,0,50,1,(array(a,[i,j])=array(b,[i])*array(c,[j])))),X,[U]),
    print(U),nl,print_code(X,0),nl,nl,fail.

 Print optimization 
    optimize(for(i,0,n,1,for(j,0,m,1,(array(a,[i,j])=array(b,[i,j])))),X,[U]),
    print(U),
    nl,print_code(X,0),nl,fail.

  for(i,0,n,1,for(j,0,m,1,for(k,0,m,1,(array(a,[i,j])=array(b,[i,k])*array(c,[k,j])))))
*/
for(H,[H|_]).
for(I,[_|L]):-for(I,L).


/*:-op(700,xfy,;).*/
:-op(690,xfx,+=).
:-op(690,xfx,*=).
:-op(690,xfx,/=).
:-op(690,xfx,-=).
:-op(690,xfx,<<=).
:-op(690,xfx,>>=).
:-op(690,xfx,@=).
:-op(690,xfx,#=).
:-op(690,xfx,~=).
:-op(690,xfx,&=).
:-op(690,xfx,^=).
:-op(690,xfx,<=).
:-op(690,xfx,>=).

:-asserta(loop(0)).
/* Portable way to do loop index creation */
/* new_loop(Y):- retract(loop(X)), N is X+1, asserta(loop(N)),number_chars(N,C),atom_chars(A,C),atom_concat(loop,A,Y).
*/
/* Swiprolog way */
new_name(P,Y):-flag(P,Old,Old+1),number_chars(Old,C),atom_chars(A,C),atom_concat(P,A,Y).
reset_name(P):-flag(P,_,0).

/************** TRANSFORMATION DESCRIPTIONS *******************/
:-use_module(optimize).
:-use_module(c_print).

xlang(explore(P,T,C,I,N)):-
     write(C),
     explore(P,T,C,P2),
     recordz(kernel,P2),fail;
     setof(XX,recorded(kernel,XX),LL),
     print_optimized(N,I,LL).

