:- module(optimize, [explore/4]).
:-use_module(analyze).

explore([H1,[H1|_]|T2],W,P,P2):-
	explore(T2,W,P,P2).
explore([H1,[_|T2]|T1],W,P,P2):-
	explore([H1,T2|T1],W,P,P2).
explore([_,[]|_],_,_,_):-fail,!.
explore([],W,P,P2):-select(W,_,P,P2).

select(T1;T2,S1;S2,P,P2):-
	select(T1,S1,P,P1),
	select(T2,S2,P1,P2).
select([T1|_],S,P,P2):-
	select(T1,S,P,P2).
select([_,H1|T1],S,P,P2):-
	select([H1|T1],S,P,P2).
select(T,T,P,P2):-
	T=..[Op|_],
	\+ member(Op,[;,nop]),
	apply(T,P,P2).
select(nop,nop,P,P).

apply(interchange(I,I),_,_):-fail,!.
apply(W,if(C,Pa,Pb),if(C,P2a,P2b)):-
	apply(W,Pb,P2b),
	apply(W,Pa,P2a).
apply(W,if(C,Pa),if(C,P2a)):-
	apply(W,Pa,P2a).
apply(W,for(LB,UB,S,P),for(LB,UB,S,P2)):-
	apply(W,P,P2).
apply(W,Pa;Pb,P2a;P2b):-
	apply(W,Pb,P2b),
	apply(W,Pa,P2a).
apply(unroll(I,UF),P,P2):-
	unroll(I,UF,P,P2),!.
apply(interchange(I,J),P,P2):-
	interchange(I,J,P,P2),!.
apply(fission(I),P,P2):-
	fission(I,P,P2).
apply(fusion(I,J),P,P2):-
	fusion(I,J,P,P2).
apply(stripmine(I,NEW,S),P,P2):-
	stripmine(I,NEW,S,P,P2).
apply(tile(I,NEW,S),P,P2):-
	tile(I,NEW,S,P,P2).
apply(deepen(I),P,P2):-
	deepen(I,P,P2).

/* Strip mine */
stripmine(I,_,1,for(id(I,T)@=LB,UB,S,B),for(id(I,T)@=LB,UB,S,B)).

stripmine(I,NEW,S,for(id(I,T)@=LB,UB,incr(id(I,T)),B1),
	  for(id(I,T)@=LB,UB,id(I,T)@=id(I,T)+S,
	      for(id(NEW,int)@=I,id(NEW,int)<I+S,incr(id(NEW,int)),B2))):-
    substitute([I/NEW],B1,B2),!.
stripmine(I,NEW,S,for(id(I,T)@=LB,UB,id(I,T)@=id(I,T)+S1,B1),
	  for(id(I,T)@=LB,UB,id(I,T)@=id(I,T)+(S*S1),
	      for(id(NEW,int)@=I,id(NEW,int)<I+(S*S1),id(NEW,int)@=id(NEW,int)+S,B2))):-
    substitute([I/NEW],B1,B2),!.

/* Interchange */
interchange(I1,I2,for(id(I1,T1)@=E1,UB1,S1,for(id(I2,T2)@=E2,UB2,S2,B)),
	 for(id(I2,T2)@=E2,UB2,S2,for(id(I1,T1)@=E1,UB1,S1,B))).
interchange(I2,I1,for(id(I1,T1)@=E1,UB1,S1,for(id(I2,T2)@=E2,UB2,S2,B)),
	 for(id(I2,T2)@=E2,UB2,S2,for(id(I1,T1)@=E1,UB1,S1,B))).

/* Fusion */
fusion(I1,I2,(for(id(I1,T)@=LB,UB,S,Z1);for(id(I2,T)@=LB,UB2,S2,Z2)),
	 for(id(I1,T)@=LB,UB,S,(Z1;Z3))):-
	substitute([I2/I1],UB2,UB),
	substitute([I2/I1],S2,S),
	substitute([I2/I1],Z2,Z3).

/* Fission */
fission_block(B1;B2,B1,B2).
fission_block(B1;B2,B1;B2a,B2b):-
	fission_block(B2,B2a,B2b).
fission_block(B1;B2,B1a,B1b;B2):-
	fission_block(B1,B1a,B1b).

fission(I,for(id(I,T)@=LB,UB,S,B1),
	 (for(id(I,T)@=LB,UB,S,B2);for(id(I,T)@=LB,UB,S,B3))):-
	fission_block(B1,B2,B3).


/* Unroll. No tail code ! */
unroll_block(_,1,P,P):-!.
unroll_block(id(J,T2),UF,for(LB,UB,S,B1),for(LB,UB,S,B2)):-
	unroll_block(id(J,T2),UF,B1,B2),!.
unroll_block(id(I,T),UF,P1,P2;P3):-
	integer(UF),
	UFM1 is UF-1,
	UFM1 > 0,
	substitute([id(I,T)/(id(I,T)+UFM1)],P1,P3),
	unroll_block(id(I,T),UFM1,P1,P2).

unroll(I,0,for(id(I,T)@=LB,UB,S,B),for(id(I,T)@=LB,UB,S,B)):-!.
unroll(I,1,for(id(I,T)@=LB,UB,S,B),for(id(I,T)@=LB,UB,S,B)):-!.
unroll(I,UF,for(id(I,T)@=LB,UB,incr(id(I,T)),B1),
       for(id(I,T)@=LB,UB,id(I,T)@=id(I,T)+UF2,B2)):-
	integer_constant(UF,UF2),
	unroll_block(id(I,T),UF2,B1,B2),!.
unroll(I,UF,for(id(I,T)@=LB,UB,id(I,T)@=id(I,T)+S,B1),
       for(id(I,T)@=LB,UB,id(I,T)@=id(I,T)+(S)*UF2,B2)):-
	integer_constant(UF,UF2),
	unroll_block(id(I,T),UF2,B1,B2),!.

/* Scalar promote */
promote(A,I,in,for(I,LB,UB,S,B1),for(I,LB,UB,S,Copyin ;B2 )):-
    find_array_ref(A,B1,L),
    substitute(L,B1,B2),    
    declare_substituted(L),
    copyin(L,Copyin).
promote(A,I,inout,for(I,LB,UB,S,B1),for(I,LB,UB,S,Copyin ;B2; Copyout )):-
    find_array_ref(A,B1,L),
    substitute(L,B1,B2),    
    declare_substituted(L),
    copyin(L,Copyin),
    copyout(L,Copyout).

/* Tile */
deepen(I1,for(id(I1,T)@=LB1,UB1,S1,for(LB2,UB2,S2,P)),
	 for(LB2,UB2,S2,P2)):-
	deepen(I1,for(id(I1,T)@=LB1,UB1,S1,P),P2),!.
deepen(I1,for(id(I1,T)@=LB1,UB1,S1,P),for(id(I1,T)@=LB1,UB1,S1,P)).
tile(I,II,S,P1,P2):-
    stripmine(I,II,S,P1,P3),
    apply(deepen(II),P3,P2).

/* Memcopy (kindof) */
memcpy(all,for(I,LB,UB,1,[A|I] @= [B|I]),memcpy(A,B,sizeof(A)*(UB-LB))).
/* Memset (kindof) */
memset(all,for(I,LB,UB,1,(array(A,[I]) @= 0)),memset(A,0,sizeof(A)*(UB-LB))).

/* Optimizing only a fragment of the code. Recursive decomposition */
new_var_name(array(_,L),array(X,L)):-
	new_name(t,X),!.
new_var_name(X,Y):-
	new_var_name(x,X,Y).
new_var_name(Name,X,Y):-
	atomic(X),new_name(Name,Y).
	

makesubst([],[],[]).
makesubst([A|T],[B|T2],[A/B|T3]):-
	makesubst(T,T2,T3).


normalize(for(I,LB,UB,S,B),for(I,LB,UB,S,B2)):-
	normalize(B,B2),!.
normalize(E1,E2):-
	E1=..[*,array(A,L),B],
	atomic(B),
	E2=..[*,B,array(A,L)],!.
normalize(E1,E2):-
	E1=..[*,array(A,L),array(B,M)],
	length(L,I),length(M,J),
	I > J,
	E2=..[*,array(B,M),array(A,L)],!.
normalize(E1,E2):-
	E1=..[Op,A1,B1],
	normalize(A1,A2),
	normalize(B1,B2),
	E2=..[Op,A2,B2],!.
normalize(E1,E2):-
	E1=..[Op,A],
	normalize(A,B),
	E2=..[Op,B],!.
normalize(A,A).

block_schedule(P1;P2,L):-
	block_schedule(P1,L1),
	block_schedule(P2,L2),
        merge_set(L1,L2,L).
block_schedule(+=(A,E),[A]):-
	recordz(schedule,+=(A,E)).

print_schedule(_,[H],H).
print_schedule(A,[H|T],P+H):-print_schedule(A,T,P).

reschedule([H],H+=P):-
	setof(XX,recorded(schedule,+=(H,XX)),LL),
	print_schedule(H,LL,P),
	findall(X,recorded(schedule,+=(H,_),X),LL2),maplist(erase,LL2).	
reschedule([H|T],(H+=P);P2):-
	setof(XX,recorded(schedule,+=(H,XX)),LL),
	findall(X,recorded(schedule,+=(H,_),X),LL2),maplist(erase,LL2),
	print_schedule(H,LL,P),
	reschedule(T,P2).

schedule(for(I,LB,UB,S,B),for(I,LB,UB,S,B2)):-
	schedule(B,B2),!.
schedule(P,P2):-
	iv(P,L),
	length(L,0),
	block_schedule(P,LL),
	reschedule(LL,P2),!.
schedule(P,P).
/************************ Decomposition ************************/

decompose(Dim,In,Out):-
	project(In,Inter,Dim),
	reset_name(t),reset_name(x),reset_name(i),
	normalize_projected(Inter,Out).

/******************** Projection ************************/
project(for(LB,UB,S,B),for(LB,UB,S,B),Dim):-
	loopindex(for(LB,UB,S,B),L),
	length(L,D),
	Dim = D,!.
project(P1;_,P2,D):-project(P1,P2,D).
project(_;P1,P2,D):-project(P1,P2,D).
project(for(_,_,_,B),B2,D):-project(B,B2,D).

normalize_projected(P,P5):-
	workingset(P,L),
	loopindex(P,I),
	maplist(projectindex(I),L,L2),flatten(L2,L3),
	maplist(new_var_name(i),I,J),
	maplist(new_var_name,L3,L4),
	makesubst(L,L4,SubstVars),
	declare_substituted(SubstVars),
	makesubst(I,J,SubstI),
	substitute(SubstVars,P,P2),
	substitute(SubstI,P2,P3),
	normalize(P3,P4),
	schedule(P4,P5).

/* Simplification of array indices due to removed loops */
projectindex(I,array(A,L1),A):-
	maplist(projectindex(I),L1,L2),flatten(L2,[]),!.
projectindex(I,array(A,L1),A):-
	maplist(projectindex(I),L1,L2),flatten(L2,L3),removecst(L3,[]),!.	
projectindex(I,array(A,L1),[array(A,L2)]):-
	maplist(projectindex(I),L1,L3),flatten(L3,L4),removecst(L4,L2),!.
projectindex(_,A,[A]):-integer(A),!.
projectindex(I,A,[]):-
	atomic(A),
	\+ member(A,I),!.
projectindex(_,A,[A]):-atomic(A),!.
projectindex(I,E1,L):-
	E1=..[Op,A1,B1],
	Op \= array,
	projectindex(I,A1,A2),
	projectindex(I,B1,B2),
	append(A2,B2,AB),
	projectBinaryOp(Op,AB,L),!.
projectindex(_,X,X).


projectBinaryOp(Op,[A1,B1],[A1]):-
    member(Op,[+,-]),
    integer(B1),!.
projectBinaryOp(Op,[A1,B1],[B1]):-
    member(Op,[+,-]),
    integer(A1),!.

projectBinaryOp(Op,[A1,B1],[A]):-
	A=..[Op,A1,B1],!.
projectBinaryOp(Op,[_],[]):-
    \+member(Op,[+,-]),!.
projectBinaryOp(_,[A],[]):-integer(A),!.
projectBinaryOp(_,[A],[A]):-!.
projectBinaryOp(_,[],[]).

removecst([],[]).
removecst([H|T],T2):-integer(H),removecst(T,T2),!.
removecst([H|T],[H|T2]):-removecst(T,T2).

/*********************** SUBSTITUTION *****************************/
substitute_list(_,[],[]):-!.
substitute_list(L,[A1|T1],[A2|T2]):-
	substitute(L,A1,A2),
	substitute_list(L,T1,T2),!.

substitute(L,A,X):-
	member(A/X,L),!.
substitute(L,for(id(I,T)@=LB,UB,S,B1),for(id(I2,T)@=LB2,UB2,S2,B2)):-
	substitute(L,I,I2),
	substitute(L,UB,UB2),
	substitute(L,LB,LB2),
	substitute(L,S,S2),
	substitute(L,B1,B2),!.
substitute(L,P1;P2,Q1;Q2):-
	substitute(L,P1,Q1),
	substitute(L,P2,Q2),!.
substitute(L,T1,T2):-
    T1=..[Op|L1],
    substitute_list(L,L1,L2),
    T2=..[Op|L2],!.
substitute(L,[H1|T1],[H2|T2]):-
	subsitute(L,H1,H2),
	substitute_list(L,T1,T2),!.

substitute(_,A,A).
copyin([A/X],X @= A).
copyin([A/X|T],X @= A; C):-
    copyin(T,C).

copyout([A/X],A @= X).
copyout([A/X|T],A @= X; C):-
    copyout(T,C).

declare_substituted([]).
declare_substituted([_/X|T]):-
    recordz(symtable,double(X)),
    declare_substituted(T).	   

