#include <stdio.h>
#include <SWI-Prolog.h>
#include <string.h>
/* Maximum number of different parameters */
#define MAXPARMS 128

typedef struct {
  char *name;
  term_t term;
} params_t;
params_t params[MAXPARMS];
static int nparams=0;

term_t new_name(const char *name) {
  int i;
  term_t ident;
  /* check whether this is a parameter */
  for (i=0; i<nparams; i++) {
    if (!strcmp(name,params[i].name)) return params[i].term;
  }
  ident = PL_new_term_ref();
  PL_put_atom_chars(ident, name);
  return ident;
}
term_t new_param(char *name) {
  term_t ident = PL_new_term_ref();
  PL_put_variable(ident);
  params[nparams].name=name;
  params[nparams].term=ident;
  nparams++;
  return ident;
}
term_t new_integer(int n) {
  term_t v = PL_new_term_ref();
  PL_put_integer(v, n);
  return v;
}
term_t new_float(double n) {
  term_t v = PL_new_term_ref();
  PL_put_float(v, n);
  return v;
}
term_t new_pred(const char *pred,int n, ...) {
  va_list ap;
  term_t p= PL_new_term_ref();
  functor_t t;
  term_t l = PL_new_term_refs(n);
  int i;
  t = PL_new_functor(PL_new_atom(pred), n);
  va_start(ap, n);
  for (i=0; i<n; i++) {
    PL_put_term(l+i,va_arg(ap,term_t));
  }
  PL_cons_functor_v(p, t, l);
  va_end(ap);
  return p;
}
term_t new_pred_v(char *pred,int n,term_t *list) {
  term_t p= PL_new_term_ref();
  functor_t t;
  term_t l = PL_new_term_refs(n);
  int i;
  t = PL_new_functor(PL_new_atom(pred), n);
  for (i=0; i<n; i++) {
    PL_put_term(l+i,list[i]);
  }
  PL_cons_functor_v(p, t, l);
  return p;
}
term_t new_list(int n,...) {
  va_list ap;
  term_t v[n];
  term_t p= PL_new_term_ref();
  int i;
  va_start(ap, n);
  PL_put_nil(p);
  for (i=0; i<n; i++) {
    v[i]=va_arg(ap,term_t);
  }
  for (i=n-1; i>=0; i--) {
    PL_cons_list(p,v[i],p);
  }
  va_end(ap);
  return p;
}
term_t add_list(term_t p,term_t n) {
  PL_cons_list(p,n,p);
  return p;
}
void init_pl(char *f) {
  char *plav[2];
  plav[0] = f;
  plav[1] = NULL;
  if ( !PL_initialise(1, plav) )
    PL_halt(1);
}

void run_pl(term_t arg) {
 
  predicate_t pred = PL_predicate("xlang", 1, "user");
  int rval = PL_call_predicate(NULL, PL_Q_NORMAL, pred, arg);
  if (rval==0) fprintf(stderr,"error in search\n");
  PL_halt(rval ? 0 : 1);
}
