#--------------------------------------------------------------------------
# genbatch.awk
# Generates a shell script for performing a test of the
# two matching algorithms (ours and Ullman's).
# Usage:
#   nawk -f genbatch.awk NODEFILE BRANCHFILE > SCRIPTFILE
# where
#   NODEFILE    the name of a text file containing 
#               the number of nodes to be used. Each line contains
#               a number of nodes and a corresponding repeat count.
#   BRANCHFILE  the name of a text file containing the ratios of
#               branches to be used. Each line contains a real number in
#               [0,1] which is the ratio between the desired number of
#               branches and the square of the number of nodes
#   SCRIPTFILE  the test shell script. You must change by hand the 
#               permissions of this file, with
#                     chmod ugo+x SCRIPTFILE
# The script output by genbatch.awk tests every combination of number of
# nodes and number of branches, generating 125 graphs and applying the
# two algorithms. The results are written on standard output, which
# should be redirected to a file to be furtherly processed by 
# mktable.awk
#-------------------------------------------------------------------------- 
BEGIN  { nodefile=ARGV[1]; ARGV[1]=""
         branchfile=ARGV[2]; ARGV[2]=""
         while ((getline < nodefile)>0)
            { node_number[nn++]=$1
              repeat[$1]=$2
            }
         while ((getline < branchfile)>0)
            branch_rate[bn++]=$1
         print "#!/usr/bin/csh"
         for(i=0; i<bn; i++)
	   { brate=branch_rate[i]
	     for(j=0; j<nn; j++)
	       { nodes=node_number[j]
		 rep=repeat[nodes]
		 branches=int(nodes*nodes*brate)
		 print ""
		 print "foreach i (1 2 3 4 5)"
		 print "  foreach j (1 2 3 4 5)"
		 print "    foreach k (1 2 3 4 5)"
		 print "      gene", nodes, branches, "foo bar"
		 print "      echo @vf", nodes, brate, rep
		 print "      matcher all foo bar", rep
		 print "      echo @ull", nodes, brate, rep
		 print "      ull_matcher all foo bar", rep
		 print "    end"
		 print "  end"
		 print "end"
	       }
	   }
      }
