/*-------------------------------------------------------
 * match.h
 * Header of match.cc
 * Declaration of the match function
 ------------------------------------------------------*/

#ifndef ULL_MATCH_H
#define ULL_MATCH_H

#include "graph.h"

/*------------------------------------------------------------
 * Definition of the match_visitor type
 * a match visitor is a function that is invoked for
 * each match that has been found.
 * If the function returns false, then the next match is
 * searched; else the seach process terminates.
 -----------------------------------------------------------*/
typedef bool (*match_visitor)(int n, node_id c1[], node_id c2[], 
                              void *usr_data);

bool match(Graph *g1, Graph *g2, int *pn, node_id c1[], node_id c2[]);

int match(Graph *g1, Graph *g2, match_visitor vis, void *usr_data=NULL);

#endif
