# prints the list of subgroups, involved by dispersion filter

G := SmallGroup( order , number );;
P := Operation( G, Elements( G ), OnRight );;
lis := AsList( P );;
subgroups := IntermediateSubgroups( P , TrivialSubgroup( P )).subgroups;; # list of all subgroups of G
normalsubgroups:=[];;

# store in normalsubgroups the list of normal subgroups
for i in [1..Length( subgroups )] do 
H := subgroups[i];;
if IsNormal(P , H) then Add( normalsubgroups, H ); fi;
od;

# print subgroups (for constraint 1 and 2 of dispersion filter)
Print( Length( subgroups ), " /* number of subgroups (for constraints 1 and 2 of dispersion filter) */\n");
for i in [1..Length( subgroups )] do
H := subgroups[i];;
Print( Order(H), " /* order of subgroup number ",i," (dispersion filter) */\n");
for x in P do
if (x in H) then
for j in [1..Length( lis )] do
if (lis[j]=x) then Print(j," "); fi; od; fi;
od;
Print("\n");
od;

# print normal subgroups (for last constraint of dispersion filter)
Print( Length( normalsubgroups ), " /* number of subgroups (for last constraint of dispersion filter) */ \n");
for i in [1..Length( normalsubgroups )] do
H := normalsubgroups[i];;
Print( Order(H), " /* order of normal subgroup number ",i," (dispersion filter) */\n");
for x in P do
if (x in H) then
for j in [1..Length( lis )] do
if (lis[j]=x) then Print(j," "); fi; od; fi;
od;
Print("\n");
od;


