# prints the list of subgroups, involved by equipartition filter 

G := SmallGroup( order , number );;
P := Operation( G, Elements( G ), OnRight );;
lis := AsList( P );;
subgroups := IntermediateSubgroups( P , TrivialSubgroup( P )).subgroups;;
subgroupsEquipartition:=[];;

# subgroups list construction for equipartition filter 
for i in [1..Length( subgroups )] do 
H := subgroups[i];;
candidate:=false;;
if IsNormal(P , H) then
candidate:=true;;
classes:=RightCosets(P,H);;

# test if exponent(G/H)<=4
for j in [1..Length( classes )] do
 c:=Representative(classes[j]);;
 orderc:=1;;
 puissc:=c;;
 while (not(puissc in H)) do
  orderc:=orderc+1;;
  puissc:=puissc*c;;
 od;;
 if (orderc>=5) then candidate:=false;; fi;;
od;

# test if G/H is abelian
for j in [1..Length( classes )] do
for k in [1..Length( classes )] do
 c:=Representative(classes[j]);;
 d:=Representative(classes[k]);;
 if (not((c*d) in RightCoset(H,(d*c)))) then candidate:=false;; fi;;
od;
od;
fi;

if (candidate=true) then Add( subgroupsEquipartition, H );; fi;;
od;

Print( Length( subgroupsEquipartition ), " /* number of subgroups for equipartition filter */\n");

for i in [1..Length( subgroupsEquipartition )] do
H := subgroupsEquipartition[i];;
Print( Order(H), " /* order of the subgroup number ",i," (equipartition filter) */\n");
for x in P do
if (x in H) then
for j in [1..Length( lis )] do
if (lis[j]=x) then Print(j," "); fi; od; fi;
od;
Print("\n");
od;

