import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;

import java.io.*;
import java.net.*;
import java.util.*;

public class interfaceNFS extends JFrame
{
    int ordreGroupe;
    int numeroGroupe;
    int omega;
    int nbRestriction=0;
    int nbProc=1;

    JPanel jpListeNumeros=new JPanel();
    JPanel jpListeOmega=new JPanel();
    JPanel jpListeFiltres=new JPanel();
    JPanel jpRestriction=new JPanel();
    JPanel jpProc=new JPanel();
    JPanel jpFaq=new JPanel();
    
    JLabel jlNbGroupe=new JLabel();
    JLabel jlNatureGroupe=new JLabel();
    
    JLabel jlRestriction=new JLabel("cut of search space:");
    JCheckBox jcb3=new JCheckBox("dispersion filter"), jcb2=new JCheckBox("equipartition filter"), jcb4=new JCheckBox("automorphism filter"), jcb6=new JCheckBox("force symmetry"), jcb5=new JCheckBox("intersection filter");

    JComboBox jcobRestriction = new JComboBox();
    JComboBox jcobProc = new JComboBox();
    JComboBox jcbFichier = new JComboBox();
    
    Vector lis=new Vector();

    boolean fichier=false;

    int i;

    // constructor
    public interfaceNFS()
    {
	setSize(640,480);
	Container c = getContentPane();
	c.setLayout( new GridLayout(2,1) );

	// jpHaut
	JPanel jpHaut = new JPanel();
	jpHaut.setLayout( new GridLayout(1,4) );

	// panneau ordre
	JPanel jpOrdre = new JPanel();
	jpOrdre.setLayout( new GridLayout(3,1) );
	
	jpOrdre.add(titre("group order"));

	JPanel jpListeOrdres = new JPanel();
	lis = listeOrdres();
	ButtonGroup bg = new ButtonGroup();
	ItemListener il = new ItemListener()
			       {
				   public void itemStateChanged( ItemEvent e )
				   {
				       JRadioButton jrbtmp = (JRadioButton) e.getItem();
				       ordreGroupe=(new Integer(jrbtmp.getLabel())).intValue();
				       jlNbGroupe.setText("Nb of groups =  "+nbGroupes(ordreGroupe));
				       jlNbGroupe.repaint();
				       
				       // mise a jour de jpListeOmega
				       jpListeOmega.removeAll();
				       lis = listeOmega(ordreGroupe);
				       ButtonGroup bg = new ButtonGroup();
				       ItemListener il = new ItemListener()
					   {
					       public void itemStateChanged( ItemEvent e )
					       {
						   JRadioButton jrbtmp = (JRadioButton) e.getItem();
						   omega=(new Integer(jrbtmp.getLabel())).intValue();
					       }
					   };
				       jpListeOmega.setLayout( new GridLayout( lis.size(),1 ));
				       JRadioButton[] jrb = new JRadioButton[ lis.size() ];
				       for (i=0; i<lis.size(); i++)
					   {
					       jrb[i]=new JRadioButton( ((Integer) lis.elementAt(i)).toString());
					       jrb[i].addItemListener(il);
					       bg.add(jrb[i]);
					       jpListeOmega.add(jrb[i]);
					   }
				       jrb[0].setSelected(true);
				       jpListeNumeros.repaint();

				       // mise a jour de jpListeNumeros
				       jpListeNumeros.removeAll();
				       lis = listeGroupesOrdre(ordreGroupe);
				       bg = new ButtonGroup();
				       il = new ItemListener()
					   {
					       public void itemStateChanged( ItemEvent e )
					       {
						   JRadioButton jrbtmp = (JRadioButton) e.getItem();
						   numeroGroupe=(new Integer(jrbtmp.getLabel())).intValue();
						   // mise a jour de jlNatureGroupe
						   if (estCyclique(ordreGroupe,numeroGroupe)) 
						       {
							   jlNatureGroupe.setText("Cyclic group");
							   jcb6.setSelected(true); // preselection de la restriction aux cas symetriques
							   jpListeFiltres.repaint();
						       }
						   else if (estAbelien(ordreGroupe,numeroGroupe)) 
						       {
							   jlNatureGroupe.setText("Abelian group");
							   jcb6.setSelected(true);
							   jpListeFiltres.repaint();
						       }
						   else
						       {
							   jlNatureGroupe.setText("Non abelian group");
							   jcb6.setSelected(false);
							   jpListeFiltres.repaint();
						       };
						   // mise a jour de jpListeFiltres
						   jpListeFiltres.removeAll();
						   jpListeFiltres.add(jcb2);
						   jpListeFiltres.add(jcb3);
						   if (filtreAutomorphismeDisponible(ordreGroupe,numeroGroupe)) jpListeFiltres.add(jcb4);
						   if (estCyclique(ordreGroupe,numeroGroupe)) jpListeFiltres.add( jcb5 );
						   jpListeFiltres.add(jcb6);
						   jpListeFiltres.repaint();
					       }
					   };
				       jpListeNumeros.setLayout( new GridLayout( lis.size(),1 ));
				       jrb = new JRadioButton[ lis.size() ];
				       for (i=0; i<lis.size(); i++)
					   {
					       jrb[i]=new JRadioButton( ((Integer) lis.elementAt(i)).toString());
					       jrb[i].addItemListener(il);
					       bg.add(jrb[i]);
					       jpListeNumeros.add(jrb[i]);
					   }
				       jrb[0].setSelected(true);
				       jpListeNumeros.repaint();
				   }
	    };
			   		
	jpListeOrdres.setLayout( new GridLayout( lis.size(),1 ));
	JRadioButton[] jrb = new JRadioButton[ lis.size() ];
	for (i=0; i<lis.size(); i++)
	    {
		jrb[i]=new JRadioButton( ((Integer) lis.elementAt(i)).toString());
		jrb[i].addItemListener(il);
		bg.add(jrb[i]);
		jpListeOrdres.add(jrb[i]);
	    }
	jpOrdre.add(new JScrollPane( jpListeOrdres));
	jpOrdre.add(jlNbGroupe);

	jpOrdre.setBorder( new EtchedBorder() );
	jpHaut.add(jpOrdre);

	// panneau numero
	JPanel jpNumero = new JPanel();
	jpNumero.setLayout( new GridLayout(3,1) );
	jpNumero.add(titre("Number of group"));

	jpListeNumeros = new JPanel();
	jpNumero.add(new JScrollPane( jpListeNumeros ));
	jpNumero.add(jlNatureGroupe);
	
	jpNumero.setBorder( new EtchedBorder() );

	jpHaut.add(jpNumero);

	// panneau taille de A (omega)
	JPanel jpTaille = new JPanel();
	jpTaille.setLayout( new GridLayout(3,1) );
	jpTaille.add(titre("Size of A"));
	jpTaille.setBorder( new EtchedBorder() );

	jpListeOmega = new JPanel();
	jpTaille.add(new JScrollPane( jpListeOmega ));

	jpHaut.add(jpTaille);

	// panneau filtres
	JPanel jpFiltres = new JPanel();
	jpFiltres.setLayout( new GridLayout(3,1) );
	jpFiltres.add(titre("Filters" ));

	jpListeFiltres=new JPanel();
	jpListeFiltres.setLayout(new GridLayout(5,1));
	jcb2.setSelected(true); // filtre equipartition selectionne par defaut
	jcb2.setToolTipText("Equipartition filter: recommended");
	jcb3.setSelected(false);
	jcb3.setToolTipText("Dispersion filter: useful if A is of small size");
	jcb4.setSelected(false);
	jcb4.setToolTipText("Automorphisms filter, may take a long time to be applied");
	jcb5.setSelected(false);
	jcb5.setToolTipText("Intersection filter: destructive filter! See F.A.Q.");
	jcb6.setSelected(false);
	jcb6.setToolTipText("Look only for solutions with A symmetric (harmless for abelian groups)");
	jpFiltres.add(jpListeFiltres);

	jpRestriction=new JPanel();
	jpRestriction.setLayout(new GridLayout(2,1));
	jcobRestriction.addItem("      None");
	jcobRestriction.addItem("        10");
	jcobRestriction.addItem("       100");
	jcobRestriction.addItem("      1000");
	jcobRestriction.addItem("    10.000");
	jcobRestriction.addItem("   100.000");
	jcobRestriction.addItem(" 1.000.000");
	jcobRestriction.addItem("10.000.000");
	jcobRestriction.addItemListener( new ItemListener()
	    {
		public void itemStateChanged( ItemEvent e )
		{
		    String S = (String) jcobRestriction.getSelectedItem();
		    if (S.equals("    Aucune")) nbRestriction=0;
		    if (S.equals("        10")) nbRestriction=10;
		    if (S.equals("       100")) nbRestriction=100;
		    if (S.equals("      1000")) nbRestriction=1000;
		    if (S.equals("    10.000")) nbRestriction=10000;
		    if (S.equals("   100.000")) nbRestriction=100000;
		    if (S.equals(" 1.000.000")) nbRestriction=1000000;
		    if (S.equals("10.000.000")) nbRestriction=10000000;
		}
	    }
					 );
	jpRestriction.add(jlRestriction);
	jpRestriction.add(jcobRestriction);
	jpFiltres.add(jpRestriction);

	jpFiltres.setBorder( new EtchedBorder() );

	jpHaut.add(jpFiltres);

	//
	c.add( jpHaut );

	// bas

	JPanel jpBas = new JPanel();
	jpBas.setLayout(new GridLayout(2,1));
	// banniere

	JLabel banniere = new JLabel("NF - Finder");
	Font texteFonte = new Font("Serif", Font.BOLD | Font.ITALIC, 32);
	banniere.setFont(texteFonte);
	banniere.setHorizontalAlignment(JLabel.CENTER);
	
	jpBas.add(banniere);

	JPanel jpBasBas= new JPanel();
	jpBasBas.setLayout(new GridLayout(1,5));

	// nb processus
	jpProc=new JPanel();
	jpProc.setLayout(new GridLayout(2,1));
	jcobProc.addItem("1");
	jcobProc.addItem("2");
	jcobProc.addItem("4");
	jcobProc.addItem("8");
	jcobProc.addItem("16");
	jcobProc.addItem("32");
	jcobProc.addItemListener( new ItemListener()
	    {
		public void itemStateChanged( ItemEvent e )
		{
		    String S = (String) jcobProc.getSelectedItem();
		    if (S.equals("1")) nbProc=1;
		    if (S.equals("2")) nbProc=2;
		    if (S.equals("4")) nbProc=4;
		    if (S.equals("8")) nbProc=8;
		    if (S.equals("16")) nbProc=16;
		    if (S.equals("32")) nbProc=32;
		}
	    }
					 );
	jpProc.add(titre("Nb processes"));
	jpProc.add(jcobProc);
	jpBasBas.add(jpProc);

	// logo
	JLabel logo = new JLabel();
	Icon image = new ImageIcon("tiger.png");
	logo.setIcon(image);
	logo.setHorizontalAlignment(JLabel.CENTER);
	jpBasBas.add(logo);

	// fichier de sortie
	fichier=true;

	// jb ( bouton start )
	JButton jb = new JButton( "Start" );
	jb.addActionListener( new ActionListener()
	    {
		public void actionPerformed( ActionEvent e)
		{
		    hide();
		    dispose();
		    System.out.println(nbProc); // nombre de processus
		    System.out.println(ordreGroupe); // ordre du groupe
		    if (nbGroupes(ordreGroupe)!=1) // numero groupe
			System.out.println(numeroGroupe); 
		    System.out.println(omega); // omega
		    if (nbRestriction==0) // restriction
			{System.out.println("n");}
		    else
			{
			    System.out.println("y");
			    System.out.println(nbRestriction);
			};
		    if (jcb2.isSelected()) // filtre equipartition 
			{System.out.println("y");}
		    else
			System.out.println("n");
		    if (jcb3.isSelected()) // filtre dispersion
			{System.out.println("y");}
		    else
			System.out.println("n");
		    if (filtreAutomorphismeDisponible(ordreGroupe,numeroGroupe)) // filtre automorphismes
			{
			    if (jcb4.isSelected()) 
				{System.out.println("y");}
			    else
				System.out.println("n");
			};
		    if (estCyclique(ordreGroupe,numeroGroupe)) // filtre intersection
			{
			    if (jcb5.isSelected()) 
				{System.out.println("y");}
			    else
				System.out.println("n");
			};
		    if (jcb6.isSelected()) // symetrie 
			{System.out.println("y");}
		    else
			System.out.println("n");
		    if (fichier) // redirection
			{System.out.println("y");}
		    else
			System.out.println("n");
		    System.exit(0);
		}
	    }
			    );
	jb.setBorder( new SoftBevelBorder( SoftBevelBorder.RAISED ) );
	jpBasBas.add(jb);

	// logo2
	logo = new JLabel();
	logo.setIcon(image);
	logo.setHorizontalAlignment(JLabel.CENTER);
	jpBasBas.add(logo);

	// button F.A.Q.
	jpFaq=new JPanel();
	jpFaq.setLayout(new GridLayout(2,1));
	JButton jbfaq = new JButton("F.A.Q");
	jbfaq.setToolTipText("Help (Frequently Asked Questions)");
	jbfaq.addActionListener(new ActionListener()
	    {
		public void actionPerformed( ActionEvent e)
		{
		    // browser
		    try
			{
			    URL page = null;
			    page = getClass().getResource("FAQ.html");
			    JEditorPane jep = new JEditorPane(page);
			    jep.setEditable(false);
			    // frame
			    JFrame jf2 = new JFrame();
			    jf2.setSize(640,480);
			    JScrollPane jsp = new JScrollPane(jep);
			    jsp.setSize(640,480);
			    (jf2.getContentPane()).add(jsp);
			    jf2.show();
			}
		    catch (IOException ioe)
			{
			    JFrame jf2 = new JFrame();
			    jf2.setSize(320,100);
			    JLabel jf2jl = new JLabel("F.A.Q. page not found");
			    jf2jl.setHorizontalAlignment(JLabel.CENTER);
			    (jf2.getContentPane()).add(jf2jl);
			    jf2.show();
			}
		}
	    });
	jpFaq.add(titre("Help"));
	jpFaq.add(jbfaq);
	jpBasBas.add(jpFaq);
	
	//
	jpBas.add(jpBasBas);

	c.add( jpBas );

	jrb[0].setSelected(true); // selection du premier groupe disponible
	show();
    }

    // methods

    public int nbGroupes(int n)
    {
	File f = new File("../../precalculated_groups/group."+n+".number");
	String text="";
	try{
	    BufferedReader dis = new BufferedReader( new InputStreamReader( new FileInputStream(f) ) );	
	    text = dis.readLine();
	}
	catch (IOException e){};
	int res = new Integer(text).intValue();
	return res;
    }

    public boolean estAbelien(int n, int i)
    {
	File f = new File("../../precalculated_groups/group."+n+"."+i+".abelian_flag");
	String text="";
	try{
	    BufferedReader dis = new BufferedReader( new InputStreamReader( new FileInputStream(f) ) );	
	    text = dis.readLine();
	}
	catch (IOException e){};
	int res = new Integer(text).intValue();
	return (res==1);
    }
    
    public boolean estCyclique(int n, int i)
    {
	File f = new File("../../precalculated_groups/group."+n+"."+i+".cyclic_flag");
	String text="";
	try{
	    BufferedReader dis = new BufferedReader( new InputStreamReader( new FileInputStream(f) ) );	
	    text = dis.readLine();
	}
	catch (IOException e){};
	int res = new Integer(text).intValue();
	return (res==1);
    }

    public boolean filtreAutomorphismeDisponible(int n, int i)
    {
	File f = new File("../../precalculated_groups/group."+n+"."+i+".automorphisms");
	return (f.exists());
    }    

    public Vector listeOmega(int n)
    {
	Vector res = new Vector();
	for (i=2; i<=(n/2); i++)
	    if (n%i==1)
		res.addElement( new Integer(i));
	return res;
    }

    public Vector listeOrdres()
    {
	File f;
	Vector res = new Vector();
	for (int i=0; i<=200; i++)
	    {
		f = new File("../../precalculated_groups/group."+i+".number");
		if (f.exists()) res.addElement(new Integer(i));
	    }
	return res;
    }

    public Vector listeGroupesOrdre( int n )
    {
	File f;
	Vector res = new Vector();
	for (int i=1; i<=nbGroupes(n); i++)
	    {
		f = new File("../../precalculated_groups/group."+n+"."+i);
		if (f.exists()) res.addElement(new Integer(i));
	    }
	return res;
    }

    public JLabel titre(String S)
    {
	JLabel tmp = new JLabel(S);
	Font fonte = new Font("Serif", Font.BOLD, 16);
	tmp.setHorizontalAlignment(JLabel.CENTER);
	tmp.setFont(fonte);
	return tmp;
    }
	

    // main
    public static void main( String p [])
    {
	interfaceNFS i = new interfaceNFS();
    }
}

 
