import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

import java.io.*;
import java.net.*;
import java.util.*;
import java.lang.reflect.*;

public class outputWindow extends JFrame
{
    int groupOrder=0;
    int groupNumber=0;
    int omega=0;
    int nbRestriction=0;
    int nbProc=1;
    int nbSol=0;

    int [] nbMaxProc;

    boolean equipartitionF=false;
    boolean dispersionF=false;
    boolean automorphismsF=false;
    boolean intersectionF=false;
    boolean restrictionF=false;
    boolean symmetryF=false;

    JProgressBar [] jpb;
    boolean [] jpbEnd;

    JTextArea jtaSolution=new JTextArea();
    String text="";
    FileInputStream fis;
    BufferedReader brfis;
    File f;

    JLabel jlSolutions = new JLabel(); 

    javax.swing.Timer timer;

    // constructor
    public outputWindow()
    {
	setSize(640,480);
	Container c = getContentPane();
	c.setLayout( new GridLayout(2,1) );

	// jpTop
	JPanel jpTop = new JPanel();
	jpTop.setLayout( new BorderLayout() );

	// jpTop titles
	JPanel jpTopTitles = new JPanel(new GridLayout(1,2));
	jpTopTitles.add(title("Parameters"));
	jpTopTitles.add(title("Filters"));
	
	// jpTop datas 		   
	JPanel jpTopDatas = new JPanel(new GridLayout(1,2));

	// load parameters
	loadParameters();

	// parameters panel
	JPanel jpParameters = new JPanel();
	jpParameters.setLayout( new GridLayout(3,1) );
	
	jpParameters.add( jl("group "+groupNumber+" of order "+groupOrder) );
	jpParameters.add( jl("size of A : "+omega));
	jpParameters.add( jl("number of processes : "+nbProc));    

	jpParameters.setBorder( new EtchedBorder() );
	jpTopDatas.add(jpParameters);

	// filters panel
	JPanel jpFilters = new JPanel();
	
	jpFilters.setLayout( new GridLayout(6,1) );
	jpFilters.setBorder( new EtchedBorder() );

	if (equipartitionF) 
	    jpFilters.add( jl( "equipartition filter" ));

	if (dispersionF) 
	    jpFilters.add( jl( "dispersion filter" ));

	if (automorphismsF) 
	    jpFilters.add( jl( "automorphisms filter" ));

	if (intersectionF) 
	    jpFilters.add( jl( "intersection filter" ));

	if (symmetryF) 
	    jpFilters.add( jl( "force symmetry filter" ));

	if (restrictionF) 
	    jpFilters.add( jl( "cut of search space" ));

	jpTopDatas.add(jpFilters);

	jpTop.add( jpTopTitles, BorderLayout.NORTH );
	jpTop.add( jpTopDatas, BorderLayout.CENTER );	

	// pub

	JLabel pub = new JLabel("NF - Finder / output window");
	Font fontText = new Font("Times", Font.BOLD | Font.ITALIC, 32);
	pub.setFont(fontText);
	pub.setHorizontalAlignment(JLabel.CENTER);
	pub.setBorder( new EtchedBorder() );
	
	jpTop.add(pub, BorderLayout.SOUTH);

	// down

	JPanel jpDown = new JPanel( new GridLayout(1,2)  );
	
	// progress bars

	JPanel jpProgressBars = new JPanel( new BorderLayout() );
	jpProgressBars.add( title( "Processes' progress bars"), BorderLayout.NORTH);

	// progress bars: inner panel
	JPanel jpInnerProgressBars = new JPanel( new GridLayout(8,1) );

	jpInnerProgressBars.setBorder( new EtchedBorder() );
	
	jpb = new JProgressBar[nbProc];
	nbMaxProc = new int[nbProc];
	jpbEnd = new boolean[nbProc];
	JPanel [] jp = new JPanel[nbProc];
	for (int i=0; i<nbProc; i++)
	    {
		// init nbMaxProc[i]
		nbMaxProc[i]=nbFile("../tmp/process_"+(i+1));
		if (nbMaxProc[i]==0) // case there is nothing to do
		    { nbMaxProc[i]=1;
			jpbEnd[i]=true;}
		else jpbEnd[i]=false;
		// init panel jp[i]
		jp[i]=new JPanel( new BorderLayout() );
		jp[i].add(new JLabel((new Integer(i+1)).toString()), BorderLayout.WEST);
		// init progress bar jpb[i]
		jpb[i]=new JProgressBar(0,nbMaxProc[i]);
		jpb[i].setValue(0);
		jpb[i].setStringPainted(true);
		jp[i].add(jpb[i], BorderLayout.CENTER);
		jpInnerProgressBars.add(jp[i]);
	    };
	jpProgressBars.add( jpInnerProgressBars, BorderLayout.CENTER );
	jpDown.add( jpProgressBars );

	// solutions

	JPanel jpSolutions = new JPanel( new BorderLayout() );
	jlSolutions = title( "0 solution" );
	jpSolutions.add( jlSolutions, BorderLayout.NORTH);

	// solutions: inner JScrollPane
	jtaSolution = new JTextArea( "Found solutions : \n" );
	jtaSolution.setMargin( new Insets(5,5,5,5) );
	jtaSolution.setEditable(false);

	f = new File("../tmp/output."+groupOrder+"."+groupNumber); 
	try{
	    fis = new FileInputStream( f );
	    brfis = new BufferedReader( new InputStreamReader(fis ));
	}
	catch (IOException e){System.out.println("File not found (file output)");};

	timer = new javax.swing.Timer(1000, new ActionListener() {
		public void actionPerformed(ActionEvent evt) {
		    // update progress bars
		    for (int i=0; i<nbProc; i++)
			{
			    if (!(jpbEnd[i]))
				{
				    jpb[i].setValue(nbMaxProc[i]-nbFile("../tmp/process_"+(i+1)));
				}
			    else jpb[i].setValue(1);
			}
		    // update output list of solutions
		    text="";
		    if (f.length()!=0)
			{
			    while (!(text==null))
				{
				    try{ 
					text=brfis.readLine(); 
				    } 
				    catch (IOException e){System.out.println("IO error");}
				    if (!(text==null))
					{
					    jtaSolution.append(text+"\n");
					    nbSol++;
					    if (nbSol==1)
						{
						    jlSolutions.setText("1 solution");
						}
					    else
						jlSolutions.setText( nbSol+" solutions");
					    jlSolutions.repaint();
					}
				}
			}
		}
	    });

	jpSolutions.add( new JScrollPane(jtaSolution), BorderLayout.CENTER );

	jpDown.add( jpSolutions);

	//
	c.add( jpTop );
	c.add( jpDown );

	timer.start();
	show();
	// System.exit(0);
    }

    // methods

    public int nbFile( String S )
    // returns the number of file in directory S
    { 
	File f = new File(S);
	return((f.listFiles()).length);
    }

    public void loadParameters()
    {
	File f = new File("datasByInterface");
	String text="";
	try{
	    BufferedReader dis = new BufferedReader( new InputStreamReader( new FileInputStream(f) ) );	
	    text = dis.readLine();
	    nbProc = new Integer(text).intValue();

	    text = dis.readLine();
	    groupOrder = new Integer(text).intValue();

	    groupNumber=1;
	    if (nbGroups(groupOrder)!=1)
		{
		    text=dis.readLine();
		    groupNumber = new Integer(text).intValue();
		};

	    text = dis.readLine();
	    omega = new Integer(text).intValue();
	    
	    text = dis.readLine();
	    restrictionF = text.equals("y");
	    if (restrictionF)
		{
		    text = dis.readLine(); // skip factor cut
		}
	    
	    text = dis.readLine();
	    equipartitionF = text.equals("y");
	    
	    text = dis.readLine();
	    dispersionF = text.equals("y");
	    
	    if (automorphismFilterAvailable(groupOrder, groupNumber))
		{
		    text = dis.readLine();
		    automorphismsF = text.equals("y");
		}
	    
	    if (isCyclic(groupOrder, groupNumber))
		{
		    text = dis.readLine();
		    intersectionF = text.equals("y");
		}
	    
	    text = dis.readLine();
	    symmetryF = text.equals("y");

	}
	catch (IOException e){System.out.println("Read error of file datasByInterface");};
    }

    public JLabel jl(String S)
    {
	JLabel tmp = new JLabel(S);
	tmp.setHorizontalAlignment(JLabel.CENTER);
	return tmp;
    }

    public JLabel title(String S)
    {
	JLabel tmp = new JLabel(S);
	Font fonte = new Font("Serif", Font.BOLD, 16);
	tmp.setHorizontalAlignment(JLabel.CENTER);
	tmp.setFont(fonte);
	return tmp;
    }
	
   public int nbGroups(int n)
    {
	File f = new File("../../precalculated_groups/group."+n+".number");
	String text="";
	try{
	    BufferedReader dis = new BufferedReader( new InputStreamReader( new FileInputStream(f) ) );	
	    text = dis.readLine();
	}
	catch (IOException e){};
	int res = new Integer(text).intValue();
	return res;
    }

    public boolean automorphismFilterAvailable(int n, int i)
    {
	File f = new File("../../precalculated_groups/group."+n+"."+i+".automorphisms");
	return (f.exists());
    }    

    public boolean isCyclic(int n, int i)
    {
	File f = new File("../../precalculated_groups/group."+n+"."+i+".cyclic_flag");
	String text="";
	try{
	    BufferedReader dis = new BufferedReader( new InputStreamReader( new FileInputStream(f) ) );	

	    text = dis.readLine();
	}
	catch (IOException e){};
	int res = new Integer(text).intValue();
	return (res==1);
    }

    // main
    public static void main( String p [])
    {
	outputWindow o = new outputWindow();
    }
}

 
