/*----------------------------------------------------------------
 * matcher.cc
 * Main module of the matcher program
 * Usage:
 *   matcher graph-file-1 graph-file-2 [repeat]
 * or:
 *   matcher all graph-file-1 graph-file-2 [repeat]
 ---------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#include "graph.h"
#include "match.h"

#define MAX_DIM 1000

void match_1(Graph &g1, Graph &g2, int rep);
void match_all(Graph &g1, Graph &g2, int rep);


int main(int argc, char *argv[])
  { if (argc!=3 && argc!=4 && argc!=5)
      { printf("Usage: matcher graph-file-1 graph-file-2 [repeat-count]\n"
               "or:    matcher all graph-file-1 graph-file-2 [repeat-count]\n"
              );
        return 1;
      }

    int all=0;
    if (strcmp(argv[1], "all")==0)
      all=1;

    Graph g1(argv[all+1]);
    Graph g2(argv[all+2]);

    int rep=1;
    if (argc==all+4)
      rep=atoi(argv[all+3]);
    
    if (!all)
      match_1(g1, g2, rep);
    else
      match_all(g1, g2, rep);
    return 0;
  }

void match_1(Graph &g1, Graph &g2, int rep)
  { 
    clock_t t1, t2;
    node_id c1[MAX_DIM];
    node_id c2[MAX_DIM];
    int n;
    bool ans=false;
    t1=clock();
    for(int i=0; i<rep; i++)
      ans=match(&g1, &g2, &n, c1, c2);
    t2=clock();

    if (ans)
      { printf("-Found match: ");
        for(int i=0; i<n; i++)
          printf("(%d,%d) ", c1[i], c2[i]);
        printf("\n");
      }
    else
      { printf("-Match not found\n");
      }

    printf("+Time: %.3f sec\n", (t2-t1)/(float)CLOCKS_PER_SEC);
  }


bool my_visitor(int, node_id [], node_id [], void *)
  { return false;
  }

void match_all(Graph &g1, Graph &g2, int rep)
  { 
    clock_t t1, t2;
    int n=0;
    t1=clock();
    for(int i=0; i<rep; i++)
      n=match(&g1, &g2, my_visitor);
    t2=clock();

    if (n)
      { printf("-Found %d matches\n", n);
      }
    else
      { printf("-Match not found\n");
      }

    printf("+Time: %.3f sec\n", (t2-t1)/(float)CLOCKS_PER_SEC);
  }

