#-----------------------------------------------------------
# mktable.awk
# Examines the results of a shell script generated
# by genbatch.awk computing averages and standard devs
# for the matching times, and outputs a table with
# these data
# Usage:
#   nawk -f mktable.awk SCRIPT_OUTPUT > TABLE
#-----------------------------------------------------------
/@/	{ gsub(/@/, "")
	  alg=$1
	  nod=$2
	  ratio=$3
	  rep=$4
	  if (!foundnod[nod])
	    { foundnod[nod]=1
	      nodenum[nodenumct++]=nod
	    }
	  if (!foundratio[ratio])
	    { foundratio[ratio]=1
	      branchratio[branchratioct++]=ratio
	    }
          algorithm[alg]=alg
	}
/+Time/ { tm=$2/rep
	  count[alg, nod, ratio]++
	  sum[alg, nod, ratio]+=tm
	  sum2[alg, nod, ratio]+=tm*tm
	}
END	{ for(i=0; i<branchratioct; i++)
	    { ratio=branchratio[i]
	      for(j in algorithm)
		{ alg=algorithm[j]
		  print "\n\nBranch ratio:", ratio," Algorithm:", alg
		  for(k=0; k<nodenumct; k++)
		    { nod=nodenum[k]
		      printf "%5d ", nod
		      ct=count[alg, nod, ratio]
		      if (ct>0)
			{ avg=sum[alg, nod, ratio]/ct
			  printf "%11.5f ", avg
                        }
		      else
			printf "%11s ", "-"
                      if (ct>1)
			{ ms=sum2[alg, nod, ratio]/ct
			  var1=ms-avg*avg
			  var2=var1*ct/(ct-1)
			  stdev=sqrt(var1)
			  printf " %11.5f ",  stdev
                        }
		      else
			printf " %11s ", "inf"
		      printf "\n"
		    }
		}
	    }
	}

