import java.lang.*;
import java.io.*;

public class find_near_factorizations
{
    public static void main(String [] p)
    {
	/** cleaning tmp directory */
	File fic = new File("tmp/split");
	if (fic.exists())
	    {
		String [] liste = fic.list();
		for (int i=0; i<liste.length; i++)
		    {
			System.out.println(liste[i]);
			fic= new File("./tmp/split/"+liste[i]);
			fic.delete();
		    };
	    }
	fic = new File("tmp/");
	if (fic.exists())
	    {
		String [] liste = fic.list();
		for (int i=0; i<liste.length; i++)
		    {
			fic= new File("./tmp/"+liste[i]);
			fic.delete();
		    };
	    }
	fic = new File("./tmp/");
	fic.mkdir(); 
	fic= new File("./tmp/split/");
	fic.mkdir();

	System.out.println("****************************************************************");
	System.out.println("*** exhaustive search of near factorization of a given group ***");
	System.out.println("****************************************************************");
	System.out.println();
	System.out.println("************************* input section ************************");

	/** read n */
	System.out.println("give the order of the group");
	DataInputStream com = new DataInputStream( System.in );
	String text="";
	try { text=com.readLine();} catch (IOException e){};
	int n=Integer.parseInt(text);
	fic = new File("tmp/n");
	try { 
	    FileOutputStream ficflux = new FileOutputStream(fic);
	    PrintWriter fictxt = new PrintWriter( ficflux ); 
	    fictxt.println(n);
	    fictxt.close();
	} catch (IOException e){};
	fic = new File("./groups/group."+n+".number");
	if (!(fic.exists()))
	    {
		System.out.println("! this order is not available !");
		System.out.println("please first use the script preprocessing_with_gap (GAP is required) !");
		return;
	    }

	/** read i */
	int i=1;
	fic = new File("tmp/i");
	try { 
	    FileOutputStream ficflux = new FileOutputStream(fic);
	    PrintWriter fictxt = new PrintWriter( ficflux ); 
	    fictxt.println(i);
	    fictxt.close();
	} catch (IOException e){};
	fic = new File("./groups/group."+n+".number");
	try { 
	    FileInputStream ficflux = new FileInputStream(fic);
	    DataInputStream fictxt = new DataInputStream( ficflux ); 
	    text=fictxt.readLine();
	    ficflux.close();
	} catch (IOException e){};
	int number = Integer.parseInt(text);
	System.out.println("There are "+number+" distinct groups of order "+n);
	if (number!=1)
	    {
		System.out.println("give the number of the group of order "+n);
		try { text=com.readLine();} catch (IOException e){};
		i=Integer.parseInt(text);
		fic = new File("tmp/i");
		try { 
		    FileOutputStream ficflux = new FileOutputStream(fic);
		    PrintWriter fictxt = new PrintWriter( ficflux ); 
		    fictxt.println(i);
		    fictxt.close();
		} catch (IOException e){};
		if (i>number)
		    {
			System.out.println("number out of range, exiting");
			return;
		    }
	    }

	/** read size of A */
	System.out.println("give the size of A of the near-factorizations (A,B)");
	try { text=com.readLine();} catch (IOException e){};
	int omega=Integer.parseInt(text);
	fic = new File("tmp/omega");
	try { 
	    FileOutputStream ficflux = new FileOutputStream(fic);
	    PrintWriter fictxt = new PrintWriter( ficflux ); 
	    fictxt.println(omega);
	    fictxt.close();
	} catch (IOException e){};
	if ((n%omega)!=1)
	    {
		System.out.println("! input size of A is not correct : exiting");
		return;
	    }

	/** test abelian */
	fic = new File("groups/group."+n+"."+i+".abelian_flag");
	try { 
	    FileInputStream ficflux = new FileInputStream(fic);
	    DataInputStream fictxt = new DataInputStream( ficflux ); 
	    text=fictxt.readLine();
	    ficflux.close();
	} catch (IOException e){};
	int sym = Integer.parseInt(text);
	if (sym==1)
	    {
		System.out.println();
		System.out.println("Warning: abelian group");
		System.out.println("--- asuming without loss of generality that A and B are symmetric subsets ---");
	    }

	/** selection of filters to be applied */
	System.out.println();
	System.out.println("********* selection of filters to be applied *******");

	/** cut of search space? */
	String ans="";
	char choixCut='n';
	int factorCut=0;
	System.out.println("Cut of search space? [n]");
	try { ans=com.readLine();} catch (IOException e){};
	if (ans.equals("y"))
	    {
		choixCut='y';
		System.out.println("Input max number of entries in input file [1000]");
		try { text=com.readLine();} catch (IOException e){};
		try { factorCut=Integer.parseInt(text);} catch (NumberFormatException e){factorCut=1000;};
	    }

	/** equipartition filter ? */
	char choix='y';
	fic = new File("../precalculated_groups/group."+n+"."+i+".equipartition_filter");
	if (fic.exists())
	    {
		System.out.println("use equipartition filter (y/n)? [y]");
		try { text=com.readLine();} catch (IOException e){};
		if (text.equals("n")) choix='n';
	    }

	/** dispersion filter ? */
	char choixbis='n';
	fic = new File("../precalculated_groups/group."+n+"."+i+".dispersion_filter");
	if (fic.exists())
	    {
		System.out.println("use dispersion filter (y/n)? [n]");
		try { text=com.readLine();} catch (IOException e){};
		if (text.equals("y")) choixbis='y';
	    }

	/** automorphisms filter ? */
	char choixbisbis='n';
	fic = new File("../precalculated_groups/group."+n+"."+i+".autmorphisms");
	if (fic.exists())
	    {
		System.out.println("warning: automorphism filter is a very expensive filter: use it only for very small values of the order of the group and size of A");
		System.out.println("use automorphisms filter (y/n)? [n]");
		try { text=com.readLine();} catch (IOException e){};
		if (text.equals("y")) choixbisbis='y';
	    }

	/** intersection filter ? */
	char choixbisbisbis='n';
	fic = new File("groups/group."+n+"."+i+".cyclic_flag");
	try { 
	    FileInputStream ficflux = new FileInputStream(fic);
	    DataInputStream fictxt = new DataInputStream( ficflux ); 
	    text=fictxt.readLine();
	    ficflux.close();
	} catch (IOException e){};
	int cyc = Integer.parseInt(text);
	if (cyc==1)
	    {
		System.out.println();
		System.out.println("Group number "+i+" of order "+n+" is a cyclic group");
		System.out.println("Warning: Warning: Intersection filter keeps subsets A such that INT(A)<=|A|-4, it is of interest only when looking for a counter-example to Grinstead s Conjecture: if applied near-factorizations (A,B) such that INT(A)>=|A|-3 will be missing");
		System.out.println("use intersection filter (y/n)? [n]");
		try { text=com.readLine();} catch (IOException e){};
		if (text.equals("y")) choixbisbisbis='y';
	    }

	/** force symmetry ? */
	if (sym==0)
	    {
		System.out.println("'look only symmetric near-factorizations (y/n)? [n]");
		try { text=com.readLine();} catch (IOException e){};
		if (text.equals("y")) sym=1;
	    }
	fic = new File("tmp/sym");
	try { 
	    FileOutputStream ficflux = new FileOutputStream(fic);
	    PrintWriter fictxt = new PrintWriter( ficflux ); 
	    fictxt.println(sym);
	    fictxt.close();
	} catch (IOException e){};
	
	/** output storage selection */
	System.out.println();
	System.out.println("******** output storage selection ******");
	int red=0;
	System.out.println("store results in a file (y/n)? [n]");
	try { text=com.readLine();} catch (IOException e){};
	if (text.equals("y")) red=1;
	fic = new File("tmp/redirection");
	try { 
	    FileOutputStream ficflux = new FileOutputStream(fic);
	    PrintWriter fictxt = new PrintWriter( ficflux ); 
	    fictxt.println(red);
	    fictxt.close();
	} catch (IOException e){};

	/** clean tmp/progression and tmp/erreur */
	fic = new File("tmp/progression");
	try { 
	    FileOutputStream ficflux = new FileOutputStream(fic);
	    PrintWriter fictxt = new PrintWriter( ficflux ); 
	    fictxt.println(0);
	    fictxt.close();
	} catch (IOException e){};
	fic = new File("tmp/erreur");
	fic.delete();
	
	/** write selections in file tmp/datas */
	fic = new File("tmp/datas");
	try { 
	    FileOutputStream ficflux = new FileOutputStream(fic);
	    PrintWriter fictxt = new PrintWriter( ficflux );
	    if (choixCut=='y'){fictxt.println(1);} /* cut search space ? */
	    else fictxt.println(0);
	    fictxt.println(factorCut); /* factorCut ? */
	    fictxt.println(sym); /* force symmetry ? */
	    if (choix=='y'){fictxt.println(1);} /* equipartition filter ? */
	    else fictxt.println(0);
	    if (choixbis=='y'){fictxt.println(1);} /* dispersion filter ? */
	    else fictxt.println(0);
	    if (choixbisbisbis=='y'){fictxt.println(1);} /* intersection filter ? */
	    else fictxt.println(0);
	    fictxt.println(n); /* order of the group */
	    fictxt.println(omega); /* size of A */ 
	    fictxt.close();
	} catch (IOException e){};

	/** output section */
	System.out.println();
	System.out.println("************************* output section ************************");
	System.out.println("groupe number "+i+" of order "+n+", size of A="+omega);
	if (sym==1)
	    System.out.println("restriction to symmetric subsets activated");
	if (choix=='y')
	    System.out.println("equipartition filter activated");
	if (choixbis=='y')
	    System.out.println("dispersion filter activated");
	if (choixbisbis=='y')
	    System.out.println("automorphisms filter activated");
	if (choixbisbisbis=='y')
	    System.out.println("intersection filter activated");
	
	/** input file generation (candidates for A) */
	System.out.println("generating input file");
	try {
	    RandomAccessFile ficsource = new RandomAccessFile("./groups/group."+n+"."+i,"r");
	    RandomAccessFile ficdest = new RandomAccessFile("./tmp/datas","rw");
	    Byte b;
	    ficdest.seek(ficdest.length());
	    for (int j=1; j<=ficsource.length(); j++)
		ficdest.writeByte(ficsource.readByte());
	    ficsource.close();
	    ficdest.close();
	}
	catch (IOException e){System.out.println("IO error 1"); return;}
	if (choix=='y') /* equipartition filter must be applied */
	    {
		try {
		    RandomAccessFile ficsource = new RandomAccessFile("../precalculated_groups/group."+n+"."+i+".equipartition_filter","r");
		    RandomAccessFile ficdest = new RandomAccessFile("./tmp/datas","rw");
		    Byte b;
		    ficdest.seek(ficdest.length());
		    for (int j=1; j<=ficsource.length(); j++)
			ficdest.writeByte(ficsource.readByte());
		    ficsource.close();
		    ficdest.close();
		}
		catch (IOException e){System.out.println("IO error 2"); return;}
	    }
	if (choixbis=='y') /* dispersion filter must be applied */
	    {
		try {
		    RandomAccessFile ficsource = new RandomAccessFile("../precalculated_groups/group."+n+"."+i+".dispersion_filter","r");
		    RandomAccessFile ficdest = new RandomAccessFile("./tmp/datas","rw");
		    Byte b;
		    ficdest.seek(ficdest.length());
		    for (int j=1; j<=ficsource.length(); j++)
			ficdest.writeByte(ficsource.readByte());
		    ficsource.close();
		    ficdest.close();
		}
		catch (IOException e){System.out.println("IO error 3"); return;}
	    }
	Process commande;
	Runtime sys = Runtime.getRuntime();
	try
	    {
		RandomAccessFile ficsource = new RandomAccessFile("tmp/datas","r");
		commande = sys.exec("./bin/generate_input_file");
		OutputStream fluxOut = commande.getOutputStream();
		InputStream fluxIn = commande.getInputStream();
		for (int j=1; j<=ficsource.length(); j++)
			fluxOut.write(ficsource.readByte());
		for (int j=1; j<=2; j++)
		    System.out.println(fluxIn.read());
		
		/* commande.waitFor(); */
	    }
	catch (IOException e){}
	/*	catch (InterruptedException e){} */
	System.out.println("input file generated: number of cases to be investigated=");
	

	/** */

    }
}
