/*------------------------------------------------------------
 * state.h
 * Header of state.cc
 * Definition of the class State
 -----------------------------------------------------------*/

#ifndef STATE_H
#define STATE_H

#include "graph.h"

/*----------------------------
 * Flags used to encode the
 * state
 ---------------------------*/
enum { ST_CORE=0x01,
       ST_TERM_IN=0x02,
       ST_TERM_OUT=0x04
     };


/*----------------------------------------------------------
 * class State
 * A representation of the SSR current state
 ---------------------------------------------------------*/
class State
  { private:
      int core_len;
      int t1in_len, t1out_len, t2in_len, t2out_len;
      node_id *core_1;
      node_id *core_2;
      byte *node_flags_1;
      byte *node_flags_2;
      Graph *g1, *g2;
      int n1, n2;
    
    public:
      State(Graph *g1, Graph *g2);
      State(const State &state);
      ~State(); 
      bool NextPair(node_id *pn1, node_id *pn2,
                    node_id prev_n1=NULL_NODE, node_id prev_n2=NULL_NODE);
      bool IsFeasiblePair(node_id n1, node_id n2);
      void AddPair(node_id n1, node_id n2);
      bool IsGoal() { return core_len==n1 && core_len==n2; };
      bool IsDead() { return n1!=n2 || 
                      ! ((t1out_len>0 && t2out_len>0) ||
                         (t1in_len>0 && t2in_len>0) ||
                         (n1-t1in_len-t1out_len>0 &&
                          n2-t2in_len-t2out_len>0));
                    };
      int CoreLen() { return core_len; }
      void GetCoreSet(node_id c1[], node_id c2[]);
  };


#endif
