/**
 * @file alloc.c
 * @brief Fonctions d'allocation mémoire.
 */

#include "alloc.h"

void check_null(const char *function, char *file, int line, int n, ...) {
    va_list ap;

    va_start(ap, n);
    for (int i = 0; i < n; i++) {
        const void *p = va_arg(ap, void *);
        char *s       = va_arg(ap, char *);
        if (p == NULL)
            PRINT_ERROR(KO, "CRITICAL", function, file, line, "%s is NULL.", s);
    }
    va_end(ap);
}
