#include "main.h"

int main(void) {
    // Initialisation du générateur de nombres aléatoires
    srandom(time(NULL));

#if TEST_STACK_BASIC
    stack *p, *r, *s;
    printf("\nTest de size_stack(), random_stack() et tower_stack().\n\n");
    p        = random_stack(20, 99);
    int size = getsize_stack(p);
    if (size != 20)
        printf("%s  random_stack(20, 99) a renvoyé une pile.\n"
               "Taille calculée par getsize() : %d au lieu de 20.\n\n",
               KO, size);
    else
        printf("%s  random_stack(20, 99) a renvoyé une pile.\n"
               "Taille calculée par getsize() : %d, OK!\n\n",
               OK, size);

    r = tower_stack(20);
    s = tower_stack(20);
    printf("%s  Affichage de 2 files de taille 20.\n"
           "   Celle de gauche a des valeurs aléatoires entre 0 et 99.\n"
           "   Celle de droite a les valeurs 1 (en haut) à 20 (en bas).\n\n",
           HINT);
    print_stacks(0, 2, p, r);

    printf("\n%s  Test de push().\n"
           "   On empile les valeurs de 40 à 49 sur la pile\n"
           "   de gauche. Le résultat est la pile de droite.\n\n",
           HINT);
    for (int i = 0; i < 10; i++) // pour provoquer un grow
        push(40 + i, s);
    print_stacks(0, 2, r, s);

    printf("\n%s  Test de pop().\n"
           "   On dépile 18 valeurs. Il ne doit rester\n"
           "   sur la pile de droite que 19 et 20.\n\n",
           HINT);
    delete_stack(s);
    s = tower_stack(20);
    for (int i = 0; i < 18; i++) // pour provoquer un shrink
        pop(s);
    print_stacks(0, 2, r, s);

    delete_stack(p);
    delete_stack(r);
    delete_stack(s);
#endif

#if TEST_COPY_STACK
    stack *p1, *p2;

    printf("\n%s  Test de copy_stack().\n"
           "   Les deux piles doivent être identiques.\n\n",
           HINT);
    p1 = random_stack(20, 99);
    p2 = copy_stack(p1);
    print_stacks(0, 2, p1, p2);
    delete_stack(p1);
    delete_stack(p2);
#endif

#if TEST_SORT_STACK
    printf("\nTest de bubble_sort_stack().\n\n");
    stack *t = random_stack(12, 99);
    printf("Avant le tri\n\n");
    print_stacks(0, 1, t);
    bubble_sort_stack(t);
    printf("Après le tri\n\n");
    print_stacks(0, 1, t);
    delete_stack(t);
#endif

#if TEST_HANOI
    printf("\n%s  Test de hanoi().\n\n", HINT);
    hanoi(4);
#endif

#if TEST_QUEUE_BASIC
    queue *qp, *qr, *qs, *qt;
    printf("\n%s  Test de random_queue() et de mountain_queue().\n\n", HINT);
    qp = random_queue(20, 50);
    qr = mountain_queue(13);
    qs = mountain_queue(3);
    qt = create_queue();
    printf("File vide :\n");
    print_queue(qt);
    printf("\n");

    printf("File aléatoire de 20 entiers (valeur maximale 50) :\n");
    print_queue(qp);

    printf("\nFile \"mountain\", entiers de 1 à 13 "
           "suivis par entiers de 13 à 1 :\n");
    print_queue(qr);

    printf("\n%s   Test de enqueue().\n\n"
           "File originale :\n",
           HINT);
    print_queue(qs);

    for (int i = 40; i < 60; i++) // pour provoquer un grow
        enqueue(i, qs);
    printf("\nFile après avoir enfilé les entiers de 40 à 59 :\n");
    print_queue(qs);

    printf("\n%s   Test de dequeue().\n\n"
           "File originale :\n",
           HINT);
    delete_queue(qs);
    qs = mountain_queue(13);
    print_queue(qs);

    for (int i = 0; i < 23; i++) // pour provoquer un shrink
        dequeue(qs);
    printf("\nFile après avoir défilé 23 valeurs. "
           "Il ne doit rester que 1, 2, 3, dans cet ordre :\n");
    print_queue(qs);

    delete_queue(qp);
    delete_queue(qr);
    delete_queue(qs);
    delete_queue(qt);
#endif

#if TEST_COPY_QUEUE
    queue *qp1, *qp2;

    printf("\n%s   Test de copy_queue().\n\n", HINT);
    qp1 = random_queue(20, 99);
    qp2 = copy_queue(qp1);
    printf("File d'origine :\n");
    print_queue(qp1);
    printf("\nFile copiée :\n");
    print_queue(qp2);
    delete_queue(qp1);
    delete_queue(qp2);
#endif

#if TEST_SORT_QUEUE
    printf("\nTest de select_sort_queue().\n\n");
    qt = random_queue(15, 100);
    printf("File avant le tri :\n");
    print_queue(qt);
    select_sort_queue(qt);
    printf("\nFile après le tri :\n");
    print_queue(qt);
    delete_queue(qt);
#endif

    return EXIT_SUCCESS;
}
