#ifndef TESTPRINT_H_
#define TESTPRINT_H_

#include "alloc.h"
#include "queue.h"
#include "stack.h"

// Pour l'affichage des piles.
// Taille maximale d'un entier dans une pile, pour l'affichage.
#define STARS              "*******"
#define MAX_SIZE_INT_STACK 7
#define PRINT_STARS                                                            \
    do {                                                                       \
        printf("%*s", MAX_SIZE_INT_STACK, STARS);                              \
    } while (0)

#define PRINT_BLANK                                                            \
    do {                                                                       \
        printf("%*s", MAX_SIZE_INT_STACK, "");                                 \
    } while (0)

// Permet l'expansion d'une macro
#define xstr(s) str(s)
// Ex: scanf("%"xstr(DMAX)"s",buffer);
#define str(s)  #s

// Fonction d'affichage d'un nombre arbitraire de piles.
//
// Cette fonction est déjà écrite (elle est utile pour afficher les tours de
// Hanoi). Elle utilise un nombre variable de parametres, comme printf.
//
// Utilisation : printstacks(h,nb,p1,p2,p3,p5,...)
//
// h est la hauteur minimale d'affichage (si h est inférieure à la hauteur de
// plus grande pile, il est remplacé par cette hauteur).
//
// nb est le nombre de piles à afficher.
//
// p1,p2,p3,p4,p5,... sont les nbs piles à afficher.
//
// Attention, la fonction est prévue pour afficher des nombres à (au plus)
// MAX_SIZE_INT_STACK chiffres. Pour afficher des piles contenant des nombres à
// plus de 7 chiffres, il faut modifier la valeur de MAX_SIZE_INT_STACK et celle
// de la macro STARS.
void print_stacks(int, int, ...);

// Fonction d'affichage d'une file.
// Cette primitive est déjà écrite. Utilisez-la pour vos tests.
void print_queue(queue *);

#endif // TESTPRINT_H_
