//////////////////////////////////////////////
// Implémentation des files par deux piles. //
//////////////////////////////////////////////

// Le fichier main.h définit la macro QUEUE_BY_TWO_STACKS.
// Vous pouvez la changer.

#include "main.h"

// Si cette macro est vraie, l'implémentation des files par deux piles est
// utilisée, et le fichier queue.c est "vidé" par le précompilateur. C'est ce
// fichier, queue_by_2_stacks.c, qui sera utilisé.

// Si la macro est fausse, l'implémentation des files par tableau circulaire est
// utilisée (fichier queue.c), et le contenu de ce fichier est "vidé".

#if QUEUE_BY_TWO_STACKS

#include "queue.h"

///////////////////////////////////////////
// Définition du type, à ne pas modifier //
///////////////////////////////////////////

typedef struct queue {
    stack *left, *right;
} queue;

///////////////////////////////////////////////////////////////////////////
// Fonctions primitives à écrire, documentées dans le fichier d'en-tête. //
///////////////////////////////////////////////////////////////////////////

queue *create_queue(void) {
    return NULL;
}

void delete_queue(queue *q) {
    return;
}

bool isempty_queue(const queue *q) {
    return false;
}

void enqueue(int val, queue *q) {
    return;
}

int dequeue(queue *q) {
    return 0;
}

/////////////////////////////////////////
// Fonction d'affichage, déjà fournie. //
/////////////////////////////////////////

static void print_queue_aux(queue *q) {
    if (isempty_queue(q)) {
        return;
    }

    int val;

    val = dequeue(q);
    print_queue_aux(q);
    printf("%4d", val);
    enqueue(val, q);
}

void print_queue(queue *q) {
    printf("File : ");
    if (isempty_queue(q)) {
        printf("(vide).\n");
        return;
    }
    print_queue_aux(q);
    printf("\n");
}

#endif // QUEUE_BY_2_STACKS
