//////////////////////////////////////////////////////
// Implémentation des files par tableau circulaire. //
//////////////////////////////////////////////////////

// Le fichier main.h définit la macro QUEUE_BY_TWO_STACKS.
// Vous pouvez la changer.

#include "main.h"

// Si cette macro est vraie, l'implémentation des files par deux piles est
// utilisée, et ce fichier, queue.c, est "vidé" par le précompilateur. C'est le
// fichier queue_by_2_stacks.c qui sera utilisé.

// Si la macro est fausse, l'implémentation des files par tableau circulaire est
// utilisée. C'est donc ce fichier, queue.c, qui sera compilé. À l'inverse, le
// contenu du fichier queue_by_2_stacks.c est "vidé" par le précompilateur.

#if QUEUE_BY_TWO_STACKS == 0

#include "queue.h"

///////////////////////////////////////////
// Définition du type, à ne pas modifier //
///////////////////////////////////////////

typedef struct queue {
    int *array;   // Tableau des valeurs.
    int capacity; // Taille du tableau des valeurs.
    int left;     // Indice de la valeur à gauche de la file (si non-vide).
    int right;    // Indice qui suit celui de la valeur à droite de la file
                  // (si elle est non-vide), modulo capacity.
    bool empty;   // Booléen indiquant si la file est vide.
} queue;

////////////////////////////////////////////////////////////////////////////////
// Fonctions auxiliaires ne pouvant pas être utilisées dans d'autres fichiers.//
// Elles ne sont pas déclarées dans queue.h et sont déclarées "static". Cela  //
// signifie qu'elles ne peuvent être utilisées QUE dans ce fichier, queue.c.  //
// /////////////////////////////////////////////////////////////////////////////

// Double la taille du tableau utilisé dans la représentation.
// Cette fonction sera utilisée lorsque le tableau est plein et qu'on veut y
// ajouter une valeur.
static void grow_queue(queue *p) {
    return;
}

// Divise par deux la taille du tableau utilisé dans la représentation
// Cette fonction sera utilisée lorsque le tableau est rempli à moins de 25% de
// sa capacité.
static void shrink_queue(queue *p) {
    return;
}

///////////////////////////////////////////////////////////////////////////
// Fonctions primitives à écrire, documentées dans le fichier d'en-tête. //
///////////////////////////////////////////////////////////////////////////

queue *create_queue(void) {
    return NULL;
}

void delete_queue(queue *q) {
    return;
}

bool isempty_queue(const queue *q) {
    return false;
}

void enqueue(int val, queue *q) {
    return;
}

int dequeue(queue *q) {
    return 0;
}

/////////////////////////////////////////
// Fonction d'affichage, déjà fournie. //
/////////////////////////////////////////

void print_queue(queue *p) {
    printf("File :");
    if (isempty_queue(p)) {
        printf(" vide\n");
        return;
    }
    int i = p->left;
    if (i < p->right)
        while (i < p->right) {
            printf("%4d", p->array[i]);
            i++;
        }
    else {
        while (i < p->capacity) {
            printf("%4d", p->array[i]);
            i++;
        }
        i = 0;
        while (i < p->right) {
            printf("%4d", p->array[i]);
            i++;
        }
    }
    printf("\n");
}

#endif // QUEUE_BY_TWO_STACKS
