/******************************/
/** Fonctions de test: files **/
/******************************/

#ifndef QUEUETEST_H_
#define QUEUETEST_H_

#include "queue.h"

//////////////////////////////////////////////////////////////
// Fonctions à écrire en utilisant les fonctions de queue.h //
//////////////////////////////////////////////////////////////

// Renvoie le nombre d'éléments dans la file, sans la modifier.
int getsize_queue(queue *);

// Crée une file aléatoire de valeurs entre 0 et maxval de taille size
// Si size est inférieure ou égal à 0, la file construite sera vide.
queue *random_queue(int, int);

// Crée une copie d'une file.
queue *copy_queue(queue *);

// Crée la file suivante :
//   1 2 3 4 .... n n .... 4 3 2 1
// Si n est inférieur ou égal à 0, la file construite est vide.
queue *mountain_queue(int);

// Trie la file par ordre croissant (la plus grande valeur à droite).
// L'algorithme devra être basé sur le principe du tri par sélection.
// Le principe de ce tri est le suivant :
// - On cherche le minimum de la file et on le place à gauche.
// - On cherche le minimum du reste de la file et on le place à sa droite.
// - On continue jusqu'à ce que la file soit triée.
// Voir https://www.cs.usfca.edu/~galles/visualization/ComparisonSort.html ou
// https://visualgo.net/en/sorting pour une visualisation de cet algorithme.
//
// La file doit être triée sur place, c'est-à-dire que la file passée en
// paramètre doit être modifiée. Aucune structure auxiliaire n'est autorisée, et
// la récursivité n'est pas autorisée non plus.
void select_sort_queue(queue *);

#endif // QUEUETEST_H_
