#include "alloc.h"
#include "print.h"
#include "stack.h"

///////////////////////////////////////////
// Définition du type, à ne pas modifier //
///////////////////////////////////////////

typedef struct stack {
    int capacity;   // Taille totale du tableau alloué en mémoire.
    int size_stack; // Nombre d'éléments dans la pile représentée.
    int *array;     // Tableau contenant les valeurs de la pile représentée.
} stack;

////////////////////////////////////////////////////////////////////////////////
// Fonctions auxiliaires ne pouvant pas être utilisées dans d'autres fichiers.//
// Elles ne sont PAS déclarées dans stack.h et sont déclarées "static". Cela  //
// signifie qu'elles ne peuvent être utilisées QUE dans ce fichier, stack.c.  //
////////////////////////////////////////////////////////////////////////////////

// Double la taille du tableau utilisé dans la représentation.
// Cette fonction sera utilisée lorsque le tableau est plein et qu'on veut y
// ajouter une valeur.
static void grow_stack(stack *p) {
    return;
}

// Divise par deux la taille du tableau utilisé dans la représentation.
// Cette fonction sera utilisée lorsque le tableau est rempli à moins de 25%
// de sa capacité.
static void shrink_stack(stack *p) {
    return;
}

////////////////////////////////////////////////////////////////
// Fonctions à écrire, documentées dans le fichier d'en-tête. //
////////////////////////////////////////////////////////////////

stack *create_stack(void) {
    return NULL;
}

void delete_stack(stack *p) {
    return;
}

bool isempty_stack(stack *p) {
    return false;
}

int pop(stack *p) {
    return 0;
}

void push(int val, stack *p) {
    return;
}

/////////////////////////////////////////
// Fonction d'affichage, déjà fournie. //
/////////////////////////////////////////

void print_stacks(int h, int nb, ...) {
    va_list liste;
    va_start(liste, nb);
    stack **tab;
    int i, j, max = 1;

    MALLOC(tab, nb);
    for (i = 0; i < nb; i++) {
        tab[i] = va_arg(liste, stack *);
        CHECK_NULL(2, tab[i], "The stack", tab[i]->array,
                   "The array used to implement the stack");
    }

    // Récupération de la hauteur maximum parmi les piles.
    for (i = 0; i < nb; i++)
        if (tab[i]->size_stack > max)
            max = tab[i]->size_stack;

    for (j = h; j > max; j--) {
        PRINT_BLANK;

        for (i = 1; i < nb; i++) {
            PRINT_BLANK;
            PRINT_BLANK;
        }
        printf("\n");
    }

    // Affichage des piles.
    for (j = max; j > 0; j--) {
        if (tab[0]->size_stack < j)
            PRINT_BLANK;
        else
            printf("%" xstr(MAX_SIZE_INT_STACK) "d", tab[0]->array[j - 1]);
        for (i = 1; i < nb; i++) {
            PRINT_BLANK;
            if (tab[i]->size_stack < j)
                PRINT_BLANK;
            else
                printf("%" xstr(MAX_SIZE_INT_STACK) "d", tab[i]->array[j - 1]);
        }
        printf("\n");
    }

    PRINT_STARS;

    for (i = 1; i < nb; i++) {
        PRINT_BLANK;
        PRINT_STARS;
    }
    printf("\n");

    free(tab);
    va_end(liste);
}
