////////////////////////////////
/// Fonctions de test: piles ///
////////////////////////////////

#ifndef STACKTEST_H_
#define STACKTEST_H_

#include "stack.h"

// Renvoie le nombre d'éléments dans la pile, sans la modifier.
int getsize_stack(stack *);

// Crée une pile aléatoire de valeurs entre 0 et maxval de taille size.
// Si size est inférieure ou égal à 0, la pile construite est vide.
stack *random_stack(int size, int maxval);

// Crée la pile suivante:
//   1
//   2
//   .
//   .
//   .
//  n-2
//  n-1
//    n
//*****
//
// Si n est inférieur ou égal à 0, la pile construite est vide.
stack *tower_stack(int n);

// Crée une copie de la pile prise en entrée.
// Cette dernière doit rester inchangée après appel de la fonction.
stack *copy_stack(stack *);

// Trie la pile par ordre croissant (la plus grande valeur au sommet).
// L'algorithme devra être basé sur le principe du tri à bulles.
// Une seule structure auxiliaire est autorisée: une seconde pile.
// Toute autre structure auxiliaire (comme un tableau) est interdite.
void bubble_sort_stack(stack *);

// Tours de Hanoi.
//
// Si n > 0, affiche la séquence de mouvements qui résout le problème des tours
// de Hanoi pour n disques. On utilisera la primitive qui sert à afficher une ou
// plusieurs piles.
//
// Par exemple, pour $n = 3$, la fonction dont afficher les informations
// suivantes: Situation initiale:
//     1
//     2
//     3
// *****     *****     *****
//
// Étape 1:
//
//     2
//     3                   1
// *****     *****     *****
//
// Étape 2:
//
//
//     3         2         1
// *****     *****     *****
//
// Étape 3:
//
//               1
//     3         2
// *****     *****     *****
//
// Étape 4:
//
//               1
//               2         3
// *****     *****     *****
//
// Étape 5:
//
//
//     1         2         3
// *****     *****     *****
//
// Étape 6:
//
//                         2
//     1                   3
// *****     *****     *****
//
// Étape 7:
//                         1
//                         2
//                         3
// *****     *****     *****
void hanoi(int n);

// Fonction récursive auxiliaire pour les tours de Hanoi.
// p1, p2, p3 sont les trois piles de départ.
// q1, q2, q3 mémorisent les trois piles de départ et ne changent pas au cours
// des appels. Utilisées pour l'affichage (on affiche q1, puis q2, puis q3).
// n est le nombre de disques à déplacer.
// max est l'espacement horizontal que prend l'affichage (utilisez max=n).
// *count permet de compter les étapes réalisées.
void hanoi_rec(stack *p1, stack *p2, stack *p3, stack *q1, stack *q2, stack *q3,
               int n, int max, int *count);

#endif // STACKTEST_H_
